# to autoload this file
proc m2Templates.tcl {} {}

#================================================================================
#  M2 Templates  #
#================================================================================

namespace eval M2 {}

#================================================================================
# Determine which routine is to be used in templates as the new line routine
# depending on the Alpha version in use

proc M2::configTemplateReturn {} {
    global templateReturn
    set templateReturn jumpEOLNewLn
    # alertnote "Having configured templateReturn"
}

# the following seems never to be executed while autoloading this m2Templates.tcl
# Bug in Alpha?  => this file can't be autoloaded to work properly
M2::configTemplateReturn

# Alpha Pre7 routine
proc oldCarrRet {} {
	carriageReturn
}

# new Alpha > 7 routine
proc jumpEOLNewLn {} {
	jumpEOLNewLnIndent ""
}


#===========================================================================
#  Aux Routines  #
#===========================================================================

proc M2::authorShip {} {
  global M2Author
  if {([info exists M2Author]) && ("$M2Author" == "First Last") | (![info exists M2Author])} then {
      alertnote "It appears you have never identified yourself and M2 mode needs now your name!"
      if {[configAuthor]} then {} 
  }
  return "$M2Author"
}

proc M2::initials {} {
  set author [M2::authorShip]
  return "[string index [lindex "$author" 0]  0][string index [lindex "$author" 1]  0]"
}


#===========================================================================
proc M2::askForModuleName {prompt} {
	set askUser 1
	set modName ""
	while {$askUser == 1} {
		set modName [getline "$prompt" "$modName"]
		set askUser 0
		if {([string length $modName] < 1)} {
			set modName ""
		}
		if {[regexp {[^A-Za-z0-9]} $modName]} then {
			set quest "$modName contains illegal characters. You wish to change it?"
			if {[askyesno $quest] == "yes"} {
		        set askUser 1
			} else {
				set modName ""
			}
		}
		if {($askUser == 0) & ([string length $modName] > 12)} then {
			set quest "$modName is too long (> 12 chars). You wish to change it?"
			if {[askyesno $quest] == "yes"} {
		        set askUser 1
			} else {
				set modName ""
			}
		}
	}
	return $modName
}

#===========================================================================
proc M2::openOrMakeFile {prompt ext} {
	if {$prompt == ""} then {
		set modName "$ext"
		set modFName "$modName"
	} else {
		set modName [M2::askForModuleName $prompt]
		set modFName "$modName.$ext"
	}
	if {$modName == ""} then { return }
	set winList [winNames]
	set foundFName [lsearch $winList $modFName]
	if { $foundFName == $modFName } then {
		# File already exists and is open
		bringToFront $modFName
	} else {
		# Create new file with the proper name
		new -n $modFName
	}
	set modName [file tail $modFName]
	set modName [file rootname $modName]
	return $modName
}


#================================================================================
#  Template Bodys  #
#================================================================================
# Note, % means next line. To customize the template expansion, find the string
# "M2 TEMPLATES". Procedure and module templates are coded as procedures (see below). Thus, be 
# careful with customizing.  Note also, there is a IF and if variant, the former spreading out
# IF THEN ELSE END(*IF*) over several lines, the latter keeping all in one line (coded as proc).

set templateBodys(CASE) "  OF%| (*. .*):%  (*. .*);%| (*. .*):%  (*. .*);%ELSE%  (*. .*);%END(*CASE*);"
set templateBodys(FOR) "  :=  TO  DO%END(*FOR*);"
set templateBodys(WHILE) " () DO%END(*WHILE*);"
set templateBodys(WITH) "  DO%END(*WITH*);"
set templateBodys(REPEAT) "%UNTIL ();"
set templateBodys(LOOP) "%END(*LOOP*);"
set templateBodys(IF) "  THEN%ELSE%END(*IF*);"
set templateBodys(if) "IF  THEN  ELSE  END;"
set templateBodys(ELSIF) "  THEN"
set templateBodys(FROM) "  IMPORT ;"



proc M2::insertTemplateBody {name} {
	global templateBodys
	set pos [getPos]
	set start [lineStart $pos]
	set indent [eval getText [search -s -r 1 -f 1 -n -- "\[ \\t\]*" $start]]
	insertText [lindex [split "$templateBodys($name)" "%"] 0]
	foreach bodyLine [lrange [split "$templateBodys($name)" "%"] 1 100] {
		insertText \r${indent}${bodyLine}
	}
	goto $pos
}



#===========================================================================
#  Template Routines  #
#===========================================================================

#================================================================================
proc smcmdCASE {} {
	# Used by calling submenu M2/Templates/CASE
	insertText "CASE"
	templateCASE
}
proc templateCASE {} {
	M2::insertTemplateBody CASE
	goto [pos::math [getPos] +1]
}

#================================================================================
proc smcmdFOR {} {
	# Used by calling submenu M2/Templates/FOR
	insertText "FOR"
	templateFOR
}
proc templateFOR {} {
	M2::insertTemplateBody FOR
	goto [pos::math [getPos] +1]
}

#================================================================================
proc smcmdWHILE {} {
	# Used by calling submenu M2/Templates/WHILE
	insertText "WHILE"
	templateWHILE
}
proc templateWHILE {} {
	M2::insertTemplateBody WHILE
	goto [pos::math [getPos] +2]
}

#================================================================================
proc smcmdWITH {} {
	# Used by calling submenu M2/Templates/WITH
	insertText "WITH"
	templateWITH
}
proc templateWITH {} {
	M2::insertTemplateBody WITH
	goto [pos::math [getPos] +1]
}

#================================================================================
proc smcmdIF {} {
	# Used by calling submenu M2/Templates/IF
	insertText "IF"
	templateIF
}

proc templateIF {} {
	M2::insertTemplateBody IF
	goto [pos::math [getPos] +1]
}

#================================================================================
proc smcmdifononeline {} { 
	# Used by calling submenu M2/Templates/if
	insertText "if"
	templateif
}

proc templateif {} {
	backSpace 
	backSpace
	set pos [getPos]
	# insertText "IF  THEN  ELSE  END;"
	M2::insertTemplateBody if
	goto [pos::math $pos + 3]
}

#================================================================================
proc smcmdELSIF {} {
	# Used by calling submenu M2/Templates/IF
	insertText "ELSIF"
	templateELSIF
}

proc templateELSIF {} {
	M2::insertTemplateBody ELSIF
	goto [pos::math [getPos] +1]
}

#================================================================================
proc smcmdREPEAT {} {
	# Used by calling submenu M2/Templates/REPEAT
	insertText "REPEAT"
	templateREPEAT
}

proc templateREPEAT {} {
	M2::insertTemplateBody REPEAT
	tabOrJumpOutOfLnAndReturn
}

#================================================================================
proc smcmdLOOP {} {
	# Used by calling submenu M2/Templates/LOOP
	insertText "LOOP"
	templateLOOP
}

proc templateLOOP {} {
	M2::insertTemplateBody LOOP
	tabOrJumpOutOfLnAndReturn
}

#================================================================================
proc smcmdFROMIMPORT {} {
	# Used by calling submenu M2/Templates/FROM IMPORT
	insertText "FROM"
	templateFROM
}

proc templateFROM {} {
	M2::insertTemplateBody FROM
	goto [pos::math [getPos] +1]
}


#================================================================================
proc smcmdPROCEDURE {} {
	# Used by calling submenu M2/Templates/PROCEDURE
	insertText "PROCEDURE"
	templatePROCEDURE
}

proc templatePROCEDURE {} {
	set winName [lindex [winNames -f] 0]
	set procName [getline "PROCEDURE Name: "]
	bringToFront $winName
	if {[string length $procName] < 1} {
		return;
	}
	set pos [pos::math [getPos] +1 +[string length $procName]]
	insertText " $procName;"
	if {[string toupper [fileExt]] != "DEF"} {
		jumpEOLNewLnIndent ""
		insertText "BEGIN (* $procName *)"
		jumpEOLNewLnIndent ""
		insertText "END $procName;"
		jumpEOLNewLnIndent ""
	}
	goto $pos
}



#================================================================================
proc smcmdNewProgramMODULE {} {
	# Used by calling submenu M2/Templates/New Program MODULE
	set modName [M2::openOrMakeFile "Program MODULE Name : " "MOD"]
	if {$modName != ""} then {
		insertText "MODULE"
		M2::modBODY $modName
	}
}

proc templateMODULE {} {
	# Used while expanding keyword MODULE
	set modName [M2::askForModuleName "Program MODULE Name: "]
	if {$modName != ""} then {
		M2::modBODY $modName
	}
}

 
#================================================================================
proc M2::modBODY {modName} {
	global M2RightShift
	global templateReturn
	# attempt to use this file with autoloading, yet this always failed. Bug in Alpha?
        if {![info exists templateReturn]} then {M2::configTemplateReturn}
	if {[string length $modName] < 1} {
		return;
	}
	insertText " $modName;"
    $templateReturn
    $templateReturn
	insertText $M2RightShift
	insertText "(*"
	$templateReturn
	insertText $M2RightShift
	insertText "Implementation and Revisions:"
	$templateReturn
	insertText "============================"
	$templateReturn
	$templateReturn
	insertText "Author  Date        Description of change"
	$templateReturn
	insertText "------  ----        ---------------------"
	$templateReturn
	insertText "[M2::initials]      [currentDate]"
	insertText "  First implementation"
	$templateReturn
	unIndent
	insertText "*)"
	$templateReturn
    $templateReturn
	set pos [getPos]
	breakTheLine
	breakTheLine
	insertText "BEGIN (* $modName *)"
	$templateReturn
	insertText "END $modName."
	$templateReturn
	goto $pos
}

#================================================================================
proc M2::defBODY {modName} {
	global M2RightShift
	global templateReturn
	global M2templateParts
	# attempt to use this file with autoloading, yet this always failed. Bug in Alpha?
        if {![info exists templateReturn]} then {M2::configTemplateReturn}
	if {[string length $modName] < 1} {
		return;
	}
	insertText " $modName;"
	$templateReturn
	$templateReturn
	insertText $M2RightShift
	insertText "(*******************************************************************"
	$templateReturn
	$templateReturn
	insertText $M2RightShift
	insertText "Module  $modName     (Version 1.0)"
	$templateReturn
	$templateReturn
	insertText $M2RightShift
	insertText "Copyright (c) [currentYear] by [M2::authorShip] "
	$templateReturn
	if {[info exists M2templateParts(copyright)] && ("$M2templateParts(copyright)" != "")} then {
    	insertText "$M2templateParts(copyright)"
    	$templateReturn
    }
	$templateReturn
	unIndent
	insertText "Purpose   (*.  purpose  .*)"
	$templateReturn
	$templateReturn
	insertText "Remarks   (*.  remarks  .*)"
	$templateReturn
	$templateReturn
	$templateReturn
	insertText "Programming"
	$templateReturn
	$templateReturn
	insertText $M2RightShift
	insertText "o Design"
	$templateReturn
	insertText $M2RightShift
	insertText "[M2::authorShip]         [currentDate]"
	$templateReturn
	$templateReturn
	unIndent
	insertText "o Implementation"
	$templateReturn
	insertText $M2RightShift
	insertText "[M2::authorShip]         [currentDate]"
	$templateReturn
	$templateReturn
	$templateReturn
	unIndent
	unIndent
	if {[info exists M2templateParts(address)] && ("$M2templateParts(address)" != "")} then {
    	insertText "$M2templateParts(address)"
    	$templateReturn
    }
	if {[info exists M2templateParts(URLs)] && ("$M2templateParts(URLs)" != "")} then {
    	insertText "$M2templateParts(URLs)"
    	$templateReturn
    }
	$templateReturn
	insertText "Last revision of definition:  [currentDate]  [M2::initials]"
	$templateReturn
	$templateReturn
	unIndent
	unIndent
	insertText "*******************************************************************)"
	$templateReturn
	$templateReturn
	insertText "(*.  exports  .*)"
	$templateReturn
	$templateReturn
	unIndent
	insertText "END $modName."
	$templateReturn
}

#================================================================================
proc smcmdNewDEFINITIONModule {} {
	# Used by calling submenu M2/Templates/New DEFINITION Module
	set modName [M2::openOrMakeFile "DEFINITION MODULE Name: " "DEF"]
	if {$modName != ""} then {
		insertText "DEFINITION MODULE"
		M2::defBODY $modName
		prevPlaceholder
		prevPlaceholder
		prevPlaceholder
	}
}

proc templateDEFINITION {} {
	# Used while expanding keyword DEFINITION
	insertText " MODULE"
	set modName [M2::askForModuleName "DEFINITION MODULE Name: "]
	if {$modName != ""} then {
		M2::defBODY $modName
		prevPlaceholder
		prevPlaceholder
	}
}

#================================================================================

proc smcmdNewIMPLEMENTATIONModule {} {
	# Used by calling submenu M2/Templates/New IMPLEMENTATION Module
	set modName [M2::openOrMakeFile "IMPLEMENTATION MODULE Name : " "MOD"]
	if {$modName != ""} then {
		insertText "IMPLEMENTATION MODULE"
		M2::modBODY $modName
	}
}

proc templateIMPLEMENTATION {} {
	# Used while expanding keyword IMPLEMENTATION
	set modName [M2::askForModuleName "IMPLEMENTATION MODULE Name: "]
	if {$modName != ""} then {
		insertText " MODULE"
		M2::modBODY $modName
	}
}


#================================================================================
#  Autogenerate IMPLEMENTATION from DEFINITION Module  #
#================================================================================
proc defToMod {} {
    global M2RightShift
    set errMsg "Operation aborted - not a syntactically correct DEFINITION MODULE"
    set winName [lindex [winNames -f] 0]
    if {$winName == ""} return
    set modName [getText [minPos] [nextLineStart [minPos]]]
    if {[lindex $modName 0] != "DEFINITION"} {
	beep
	alertnote "$errMsg"
	return
    }
    if {[lindex $modName 1] != "MODULE"} {
	beep
	alertnote "$errMsg"
	return
    }
    set modName [lindex $modName 2]
    set modName [string range $modName 0 [expr [string length $modName] - 2]]
    if {$modName == ""} {
	beep
	alertnote "$errMsg"
	return
    }
    set modName [M2::openOrMakeFile "" "$modName.MOD"]
    insertText "IMPLEMENTATION MODULE "
    M2::modBODY $modName
    set newName [lindex [winNames -f] 0]
    unIndent
    bringToFront $winName
    # Copy all imports
    set pos [search -s -r 1 -f 1 -i 0 -n -- "FROM|IMPORT" [minPos]]
    set end [search -s -r 1 -f 1 -i 0 -n -- "TYPE|PROCEDURE|VAR|CONST|END" [minPos]]
    if {$pos != ""} {
	set text [getText [lineStart $pos] [lineStart $end]]
	insertText -w $newName $text
    }
    insertText -w $newName "\r$M2RightShift"
    set finalCursPos [getPos -w $newName]
    insertText -w $newName "\r\r"
    # Copy all procedure declarations and generate for each an empty body
    set end [minPos]
    set matchStr "PROCEDURE\[ \\t\]*\[A-Za-z0-9\]+\[ \\t\]*(\\(\[^\\)\]*\\))?\[^\\;\]*\;"
    set matchParListEnd "(\\(\[^\\)\]*\\))\[ \\t\]*\[^\\;\]*\;"
    set pos [search -s -r 1 -f 1  -i 0 -n -- $matchStr $end]
    set end [lindex $pos 1]
    while {$pos != "" } {
	set text [getText [lineStart $pos] [nextLineStart [lindex $pos 1]]]
	set insertion [format "%[string first [lindex $text 0] $text]s" ""]
	set procName [lindex [split "[lindex $text 1]" "(;"] 0]
	if {[regexp {\([^\*]} $text]} then {
	    # alertnote "procedure $procName has formal parameters"
	    if {![regexp {[^\*]\)} $text]} then {
		# alertnote "not entire parameter list yet found, search for rest"
		set from $end
		set pos [search -s -r 1 -f 1  -i 0 -n -- $matchParListEnd $end]
		set end [lindex $pos 1]
		set text [getText [lineStart $from] [nextLineStart $end]]
	    }
	}
	insertText -w $newName $text
	insertText -w $newName $insertion
	insertText -w $newName "BEGIN (* $procName *)"
	insertText -w $newName "\r"
	insertText -w $newName $insertion
	insertText -w $newName "END $procName;"
	insertText -w $newName "\r\r"	
	set pos [search -s -r 1 -f 1  -i 0 -n -- $matchStr $end]
	set end [lindex $pos 1]
    }
    bringToFront $newName
    changeMode M2
    # kill extra line at end
    nextLine
    backSpace
    nextLine
    # Add body of init proc
    set initProc "Init$modName"
    insertText $M2RightShift
    insertText "PROCEDURE $initProc;"
    insertText "\r$M2RightShift"
    insertText "BEGIN (*$initProc*)"
    insertText "\r$M2RightShift"
    insertText "END $initProc;"
    insertText "\r$M2RightShift"
    insertText "\r"
    nextLine
    insertText $M2RightShift
    insertText "$initProc;"
    insertText "\r"
    # Set cursor between imports and first proc
    goto $finalCursPos
}




# Reporting that end of this script has been reached
message "m2Templates.tcl for Programing in Modula-2 loaded"
if {$installDebugFlag} then {
    alertnote "m2Templates.tcl for Programing in Modula-2 loaded"
}
